using System;
using Server;

namespace Server.Items
{
	public class OphidianBardiche : LevelBardiche
	{
		public override int ArtifactRarity{ get{ return 46; } }
      
		public override int AosStrengthReq{ get{ return 70; } }
		public override int AosMinDamage{ get{ return 15; } }
		public override int AosMaxDamage{ get{ return 17; } }
		public override int AosSpeed{ get{ return 28; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public OphidianBardiche()
		{
			Hue = 1397;
         Name = "ophidian bardiche";
			Attributes.WeaponSpeed = 30;
			Attributes.WeaponDamage = 50;
         
         NewPrimaryAbility = WeaponAbility.AbilityType.ArmorIgnore;
         NewSecondaryAbility = WeaponAbility.AbilityType.DoubleStrike;
		}
      
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
         list.Add( (int) TalismanSlayerName.Ice );
         list.Add( (int) TalismanSlayerName.Flame );
		}

		public OphidianBardiche( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 );
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}